@extends('layouts.master')
@section('title',__('Featured Post Setting'))
@section('breadcum')
  <div class="breadcrumbbar">
    <h4 class="page-title">{{ __('Featured Post Setting') }}</h4>
      <div class="breadcrumb-list">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('Featured Post') }}</li>
          </ol>
      </div>   
  </div>
@endsection
@section('maincontent')
<div class="contentbar">
  <div class="row">
    @if ($errors->any())  
  <div class="alert alert-danger" role="alert">
  @foreach($errors->all() as $error)     
  <p>{{ $error}}<button type="button" class="close" data-dismiss="alert" aria-label="Close" title="{{ __('Close') }}">
  <span aria-hidden="true" style="color:red;">&times;</span></button></p>
      @endforeach  
  </div>
  @endif
    <div class="col-lg-12">
      <div class="card m-b-50">
        <div class="card-header">
          <a href="{{url('admin/blog')}}" class="float-right btn btn-primary-rgba mr-2" title="{{ __('Back') }}"><i
            class="feather icon-arrow-left mr-2"></i>{{ __('Back') }}</a>
          <h5 class="box-title">{{__('Featured Post Setting')}}</h5>
        </div>
        <div class="card-body ml-2">
          {!! Form::open(['method' => 'POST', 'action' => 'FetauredBlogController@update', 'files' => true]) !!}
          <div class="row">
            
              <!-- Blog Names (Multiple Choice) -->
              <div class="col-md-4">
                <div class="form-group text-dark{{ $errors->has('blog_names') ? ' has-error' : '' }}">
                    {!! Form::label('blog_names', __('Choose Blog Names')) !!}<sup class="text-danger">*</sup>
                    {!! Form::select('blog_names[]', $data->blogNames, isset($data2->blog_names) ? $data2->blog_names : null, ['class' => 'form-control select2', 'multiple' => 'multiple', 'required']) !!}
                    <small class="text-danger">{{ $errors->first('blog_names') }}</small>
                </div>
            </div>
            
            <!-- Start Date -->
              <div class="col-md-4">
                  <div class="form-group text-dark{{ $errors->has('start_date') ? ' has-error' : '' }}">
                      {!! Form::label('start_date', __('Start Date')) !!}<sup class="text-danger">*</sup>
                      {!! Form::date('start_date', isset($data2['start_date']) ? $data2['start_date'] : old('start_date'), ['class' => 'form-control', 'required']) !!}
                      <small class="text-danger">{{ $errors->first('start_date') }}</small>
                  </div>
              </div>
      
              <!-- End Date -->
              <div class="col-md-4">
                  <div class="form-group text-dark{{ $errors->has('end_date') ? ' has-error' : '' }}">
                      {!! Form::label('end_date', __('End Date')) !!}<sup class="text-danger">*</sup>
                      {!! Form::date('end_date', isset($data2['end_date']) ? $data2['end_date'] : old('end_date'), ['class' => 'form-control', 'required']) !!}
                      <small class="text-danger">{{ $errors->first('end_date') }}</small>
                  </div>
              </div>
      
              <!-- Submit Button -->
              <div class="col-md-12">
                  <div class="form-group">
                      <button type="submit" class="btn btn-primary-rgba" title="{{ __('Save') }}">
                          <i class="fa fa-check-circle"></i> {{ __('Save') }}
                      </button>
                  </div>
              </div>
          </div>
          {!! Form::close() !!}
          <div class="clear-both"></div>
      </div>
      
    </div>
  </div>
</div>
@endsection 